/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class Tooltips {
    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack mStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        if (info.getLines().isEmpty()) {
            return;
        }
        int rectX = rect.func_199318_a() - 8;
        int rectY = rect.func_199319_b() + 18;
        int maxTextWidth = rect.func_199316_c() - 8;
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, info.getLines(), mStack, rectX, rectY, screenWidth, screenHeight, maxTextWidth, info.getFont());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        rectX = event.getX();
        rectY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        info.setFont(event.getFontRenderer());
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = info.getMaxLineWidth();
        boolean needsWrap = false;
        int tooltipX = rectX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = rectX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = rectX > screenWidth / 2 ? rectX - 12 - 8 : screenWidth - 16 - rectX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            info.wrap(tooltipTextWidth);
            tooltipTextWidth = info.getTooltipWidth();
            tooltipX = rectX + 12;
        }
        int tooltipY = rectY - 12;
        int tooltipHeight = 8;
        if (info.getLines().size() > 1) {
            tooltipHeight += (info.getLines().size() - 1) * 10;
            if (info.getLines().size() > info.getTitleLines()) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, info.getLines(), mStack, tooltipX, tooltipY, info.getFont(), backgroundColor, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        mStack.func_227860_a_();
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, info.getLines(), mStack, tooltipX, tooltipY, info.getFont(), tooltipTextWidth, tooltipHeight));
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        mStack.func_227861_a_(0.0, 0.0, 400.0);
        int tooltipTop = tooltipY;
        for (int lineNumber = 0; lineNumber < info.getLines().size(); ++lineNumber) {
            ITextProperties line = info.getLines().get(lineNumber);
            if (line != null) {
                info.getFont().func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == info.getTitleLines()) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.func_228461_a_();
        mStack.func_227865_b_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, info.getLines(), mStack, tooltipX, tooltipTop, info.getFont(), tooltipTextWidth, tooltipHeight));
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    public static Rectangle2d calculateRect(ItemStack stack, MatrixStack mStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        int n;
        Rectangle2d rect = new Rectangle2d(0, 0, 0, 0);
        if (textLines.isEmpty()) {
            return rect;
        }
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return rect;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        font = event.getFontRenderer();
        int tooltipTextWidth = 0;
        for (ITextProperties iTextProperties : textLines) {
            int textLineWidth = font.func_238414_a_(iTextProperties);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 14;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 14 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < textLines.size(); ++i) {
                ITextProperties textLine = textLines.get(i);
                List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = font.func_238414_a_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((ITextProperties)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 14;
        }
        int tooltipY = mouseY - 14;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        rect = new Rectangle2d(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8);
        return rect;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private FontRenderer font;
        private List<? extends ITextProperties> lines = new ArrayList<ITextProperties>();

        public TooltipInfo(List<? extends ITextProperties> lines, FontRenderer font) {
            this.lines = lines;
            this.font = font;
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public FontRenderer getFont() {
            return this.font;
        }

        public List<? extends ITextProperties> getLines() {
            return this.lines;
        }

        public void setFont(FontRenderer font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            int textWidth = 0;
            for (ITextProperties iTextProperties : this.lines) {
                int textLineWidth = this.font.func_238414_a_(iTextProperties);
                if (textLineWidth <= textWidth) continue;
                textWidth = textLineWidth;
            }
            return textWidth;
        }

        public void wrap(int maxWidth) {
            this.tooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < this.lines.size(); ++i) {
                ITextProperties textLine = this.lines.get(i);
                List wrappedLine = this.font.func_238420_b_().func_238362_b_(textLine, maxWidth, Style.field_240709_b_);
                if (i == 0) {
                    this.titleLines = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = this.font.func_238414_a_(line);
                    if (lineWidth > this.tooltipWidth) {
                        this.tooltipWidth = lineWidth;
                    }
                    wrappedLines.add((ITextProperties)line);
                }
            }
            this.lines = wrappedLines;
        }
    }
}

